<?php
/** @var array $data The object we are going to view */
$pageTitle='Construct: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();

    grid.box({
		classes:'r1 c1 h1 w1',
		content:'This is only for testing and development. Go to the project page for a better way to work with proteins, constructs and sequences.'
	});

    const detailsBox = grid.box({
        classes: 'r2 c1 h2 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/construct/' + data['id'],
        method: 'patch',
    });
    frm.textField({ label:"Name", name:'name', value:data['name'] });
	frm.textField({ label:"Description", name:'description', value:data['description'] });
	let role={
		readonly:true,
		label:"Protein", 
		name:'proteinid',
		otherName:'Click to view',
		otherId:data['proteinid'],
		otherType:'protein',
		labelField:'name',
		headers:['Name'],
		cellTemplates:['{{name}}']
	};
    if(!isAdmin){
        role['constraint']={ 'owner':userId };
    }
    frm.roleField(role);
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
