<?php $pageTitle='Create a container';
include realpath(__DIR__).'/../../core/_common/header.php';
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id']; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/container/',
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.roleField({
			label:"Type", 
			name:'containertypeid', 
			otherType:'containertype',
			labelField:'name',
			headers:['Name','Category','Positions'],
			cellTemplates:['{{name}}','{{containercategoryname}}','{{positions}}']
	});
	frm.textField({ label:"Name", name:'name', value:'' });
	frm.createButton();
	
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
