<?php
/** @var array $data The object we are going to view */
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
$pageTitle=$data['containertypename'].': '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/container/' + data['id'],
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name' });
	frm.formField({ label:"Type", content:'<a href="/containertype/'+data.containertypeid+'">'+data["containertypename"]+'</a>' });
	frm.formField({ label:"Category", content:'<a href="/containercategory/'+data["containercategoryid"]+'">'+data["containercategoryname"]+'</a>' });

    const ts = grid.tabSet({classes: 'r1 c2 w2 h3'});

    ts.tab({
		'label':'Contents',
		'id':'contents',
		'content':'Loading...'
	});
	
	ts.filesTab();
	ts.notesTab();

    const canEmptyContainer = isAdmin || isTechnician || window["isShipper"];
    Container.getAllContents(data, function(){
		Container.showAllContents(data, document.getElementById("contents_body"), canEmptyContainer);
	});
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
