<?php 
/**
 * This is the crystal fishing UI.
 */
$pageTitle='Fishing crystals';
$breadcrumbs=array();
$hasConfig=true;
/** @noinspection PhpUnhandledExceptionInspection */
$canShip = shipment::canCreate();
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
/** @var string $wwwroot The document root */
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript" src="<?php echo '/js/model/fishing/fishing.js?t='.@filemtime($wwwroot.'/client/js/model/fishing/fishing.js'); ?>"></script>
<script type="text/javascript">
const canShip=<?php echo $canShip ? 'true' : 'false'; ?>;
const startBarcodes=[<?php if(isset($_GET['barcodes'])){ echo '"'.implode('","',explode(',',$_GET['barcodes'])).'"'; } ?>];

window.addEventListener('DOMContentLoaded',function(){

	ui.keepAlive();

    const grid = ui.grid(false, 'fishinggrid'); //which we'll ignore, but the CSS may depend on the nesting

    const scanBox = grid.box({
        id: "scanbox",
        title: 'Barcode entry',
        content: ''
    });
    const f = scanBox.form({
        autosubmit: false,
        id: "barcodeform"
    });
    const barcodeField = f.textField({
        name: "barcode",
        label: "",
        value: "",
        helpText: "If not using a barcode scanner, type the barcode and press Enter"
    }).querySelector("input");
    barcodeField.placeholder="Scan a plate, pin, puck or dewar barcode";
    barcodeField.autocomplete="off";

    grid.box({
        id: "trashbox",
        title: 'Remove containers',
        content: 'Drag containers here to remove them from the bench'
    });

    grid.box({
        id: "platebox",
        title: 'Plate',
        content: ''
    });

    grid.box({
        id: "pinsbox",
        title: 'Pins',
        content: ''
    });

    const pucksAndDewarsBox = grid.box({
        id: "pucksdewarsbox",
        title: 'Pucks and dewars',
        content: ''
    });

    const pucksBox = document.createElement("div");
    pucksBox.id="pucksbox";
    pucksAndDewarsBox.appendChild(pucksBox);

    const dewarsBox = document.createElement("div");
    dewarsBox.id="dewarsbox";
	pucksAndDewarsBox.appendChild(dewarsBox);

	Fishing.init();
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
