<?php
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
$sharedProjectId=$sharedProject['id'];
if (!$sharedProject) {
	throw new NotFoundException('Could not read shared project');
}/** @var array $data The object we are going to view */
$pageTitle='Container contents: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
window.addEventListener('DOMContentLoaded',function(){
	const grid=ui.grid();
	const detailsBox=grid.box({
		classes:'r1 c1 h3 w1',
		title:'Details'
	});
	const frm=detailsBox.form({
		action:'/api/containercontent/'+data['id'],
		method:'post',
		readonly:true
	});
	frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name' });
	frm.textField({ label:"Parent", name:'parent' });
	frm.textField({ label:"Child", name:'child' });
	frm.checkbox({ label:"Is current", name:'iscurrent' });
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
