<?php
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
/** @var array $data The object we are going to view */
$pageTitle='Container type: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/containertype/' + data['id'],
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name' });
	frm.textField({ label:"Positions", name:'positions' });
	frm.formField({ label:"Category", content:'<a href="/containercategory/'+data["containercategoryid"]+'">'+data["containercategoryname"]+'</a>' });

    const ts = grid.tabSet({classes: 'r1 c2 w2 h3'});
    ts.tab({
		'label':'Containers',
		'url':'/api/container/containertypeid/'+data.id+'',
		'sortBy':'name',
		'sortDescending':true,
		'headers':['Name'],
		'sortOrders':['name'],
		'cellTemplates':['<a href="/container/{{id}}">{{name}}</a>']
	});
	ts.filesTab();
	ts.notesTab();
		
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
