<?php $pageTitle='Imagers';
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
let manualImagingAllowed=<?php echo (config::get('imaging_allowmanual')) ? 'true' : 'false'; ?>;
window.addEventListener('DOMContentLoaded',function(){

    const sortOrders = ['name', 'friendlyname', 'isinuse', 'platecapacity', 'platesactive', 'platesexpired','manualimaging'];
    const headers = ['Serial', 'Description', 'In use', 'Capacity', 'Active', 'Expired', 'Manual'];
    const cellTemplates = ['<a href="/imager/{{id}}">{{name}}</a>', '{{friendlyname}}', [ui.checkmark,'isinuse'], '{{platecapacity}}', '{{platesactive}}', '{{platesexpired}}', [ui.checkmark,'manualimaging'] ];
    if(!manualImagingAllowed){
		headers.splice(-1);
		cellTemplates.splice(-1);
		sortOrders.splice(-1);
	}
	ui.grid().box({ 
		classes:'r1 c1 h3 w3',
		url:'/api/imager',
		headers:headers,
		cellTemplates:cellTemplates,
		sortOrders:sortOrders,
		sortBy:"platecapacity",
		sortDescending:true
	});

});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';