<?php
/** @var array $data The object we are going to view */
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
$pageTitle='PDB deposition: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/pdbdeposition/' + data['id'],
        method: 'post',
        readonly: true
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
    frm.formField({ label:"PDB code", content:data["name"] });

    let shortCode=data.name.replace("pdb_0000","").toLowerCase();
    let content='';
    content+='<a style="" target="_blank" href="https://www.ebi.ac.uk/pdbe/entry/pdb/'+shortCode+'" title="View this structure at PDBe"><img src="/images/icons/external/pdbe.png" alt="PDBe" /></a>';
    content+='<br/><a target="_blank" href="https://www.rcsb.org/structure/'+shortCode+'" title="View this structure at RCSB PDB"><img src="/images/icons/external/rcsb.png" alt="RCSB PDB" /></a>';
    content+='<br/><a target="_blank" href="https://pdbj.org/mine/summary/'+shortCode+'" title="View this structure at PDBj"><img src="/images/icons/external/pdbj.svg" alt="PDBj" /></a>';

    let lbl=frm.formField({ label:"PDB resources", content:content });
    lbl.querySelectorAll("a").forEach(function(a){
        a.style="display:inline-block; background-color:white; border-radius:0.5em; height: 2em; width: 8em; text-align: center;"
    });
    lbl.querySelector("a").style.marginTop="0.5em";

    content='';
    content+='<a target="_blank" href="https://proteopedia.org/wiki/index.php/'+shortCode+'" title="View this structure at Proteopedia"><img src="/images/icons/external/proteopedia.gif" alt="PDBe" /></a>';
    lbl=frm.formField({ label:"Proteopedia", content:content });

    let link=lbl.querySelector("a");
    link.style.display="inline-block";
    link.style.backgroundColor="white";
    link.style.borderRadius="0.5em";
    link.style.width="8em";
    link.style.textAlign="center";
    link.style.marginTop="0.5em";
    link.style.marginBottom="0.5em";
    link.querySelector("img").style.height="6em";
    link.querySelector("img").style.marginBottom="0";

    let ts=grid.tabSet({ classes:'r1 c2 w2 h3' });

    Dataset.listTab(ts, 'pdbdepositionid', data['id']);

    ts.tab({
        'label':'Crystals',
        'id':'crystals',
        'url':'/api/pdbdeposition/'+data['id']+'/crystal',
        headers:['Rating','Image','Plate','Crystal'],
        cellTemplates:[ [ui.starRatingCellContents,'starrating'], [Crystal.getThumbnailLink,'id'], '<a href="/plate/{{plateid}}/">{{platename}}</a>', [Crystal.getTextLink,'id'] ],
    });

	ts.filesTab();
	ts.notesTab();

});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';