<?php $pageTitle='Create a plate type';
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/platetype/',
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name', value:'' });
	frm.textField({ label:"Number of rows", name:'rows', value:'8' });
	frm.textField({ label:"Number of columns", name:'cols', value:'12' });
	frm.textField({ label:"Drops per well", name:'subs', value:'' });
	frm.textField({ label:"Drop mapping", name:'dropmapping', value:'' });
	frm.createButton();

	grid.box({
		classes:'r1 c2 h3 w2',
		title:'Creating plate types',
		content:'<p>If IceBear is connected to an imaging system, it\'s usually better to import plate types from there automatically.</p>'
	});

});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
