<?php
/** @var array $data The object we are going to view */
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
$pageTitle='Plate type: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/platetype/' + data['id'],
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name' });
	frm.textField({ label:"Number of rows", name:'rows' });
	frm.textField({ label:"Number of columns", name:'cols' });
	frm.textField({ label:"Drops per well", name:'subs' });
	frm.textField({ label:"Drop mapping", name:'dropmapping' });

    const ts = grid.tabSet({classes: 'r1 c2 w2 h3'});
    ts.tab({
		'label':'Plates',
		'url':'/api/plate/platetypeid/'+data.id+'',
		'sortBy':'name',
		'sortDescending':true,
		'headers':['Plate','Project'],
		'sortOrders':['name','project.name'],
		'cellTemplates':[ '<a href="/plate/{{id}}">{{name}}</a>', [Project.getLink,'name'] ]
	});
	ts.filesTab();
	ts.notesTab();
		
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
