<?php
/** @var array $data The object we are going to view */
$pageTitle='Protein: '.$data['name'];
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){
    const grid = ui.grid();

    grid.box({
        classes: 'r1 c1 h1 w1',
        content: 'This is only for testing and development. Go to the project page for a better way to work with proteins, constructs and sequences.'
    });

    const detailsBox = grid.box({
        classes: 'r2 c1 h2 w1',
        title: 'Details'
    });

    const frm = detailsBox.form({
        action: '/api/protein/' + data['id'],
        method: 'patch',
    });
    frm.textField({ label:"Name", name:'name', value:data['name'] });
	frm.textField({ label:"Protein acronym", name:'proteinacronym', value:data['proteinacronym'] });
	frm.textField({ label:"Description", name:'description', value:data['description'] });
	frm.roleField({ 
		label:"Project", 
		name:'projectid',
		otherName:data['projectname'],
		otherId:data['projectid'],
		otherType:'project',
		constraint:{ 'owner':userId }, //TODO only if !admin
		labelField:'name',
		headers:['Name'],
		cellTemplates:['{{name}}'],
		readonly:true
	});

    grid.box({
        classes: 'r1 c2 h3 w2',
        title: 'Constructs',
        url: '/api/protein/' + data['id'] + '/construct',
        headers: ['Name'],
        cellTemplates: ['<a href="/construct/{{id}}">{{name}}</a>']
    });


});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
