<?php
/** @var array $data The object we are going to view */
$pageTitle='Shipments';
/** @noinspection PhpUnhandledExceptionInspection */
$showCreateLink=$canShip=shipment::canCreate();

include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">
window.addEventListener('DOMContentLoaded',function(){

	let headers=['Name','Destination','Shipper','Proposal','Date shipped','Date returned'];
	let sortOrders=['name','shipmentdestination.name','user.fullname','proposalname','dateshipped','datereturned'];
	let cellTemplates=[
       	'<a href="/shipment/{{id}}">{{name}}</a>',
        '<a href="/shipmentdestination/{{shipmentdestinationid}}">{{shipmentdestinationname}}</a>',
        '<a href="/user/{{shipperid}}">{{shippername}}</a>',
        '{{proposalname}}',
	    [ui.fieldToFriendlyDate,'dateshipped'],
	    [ui.fieldToFriendlyDate,'datereturned'],
	];
	let showFilters=[true,true,true,true,false,false];

	ui.grid().box({ 
		classes:'r1 c1 h3 w3',
		url:'/api/shipment?sortby=id&sortdescending=yes',
		headers:headers,
		sortOrders:sortOrders,
		cellTemplates:cellTemplates,
        showFilters:showFilters
	});


});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';