<?php $pageTitle='Create a shipment destination';
/** @var array $data The object we are going to view */
/** @noinspection PhpUnhandledExceptionInspection */
$sharedProject=project::getByName(baseproject::SHARED);
if(!$sharedProject){
	throw new NotFoundException('Could not read shared project');
}
$sharedProjectId=$sharedProject['id'];
$shipmentHandlers=shipmentdestination::getHandlerScriptNames();
include realpath(__DIR__).'/../../core/_common/header.php'; ?>
<script type="text/javascript">

window.addEventListener('DOMContentLoaded',function(){

    const grid = ui.grid();
    const detailsBox = grid.box({
        classes: 'r1 c1 h3 w1',
        title: 'Details'
    });
    const frm = detailsBox.form({
        action: '/api/shipmentdestination/',
        method: 'post',
    });
    frm.hiddenField('projectid',<?php echo $sharedProjectId; ?>);
	frm.textField({ label:"Name", name:'name', value:'' });

	frm.dropdown({ label:"Shipment handler", name:"shipmenthandler", 
		options:[
			<?php 
			     $parts=array();
			     foreach($shipmentHandlers as $h){
			         $parts[]='{ "value":"'.$h.'","label":"'.$h.'" }';
			     } 
			     echo implode(', ', $parts);
			?>
		],
		value:'DefaultShippingHandler'
	});
	frm.textField({ label:"Base URI", name:'baseuri' });
	frm.createButton();
	
});
</script>
<?php include realpath(__DIR__).'/../../core/_common/footer.php';
