<?php 
global $icebearSessionStarted;
if(!$icebearSessionStarted){
	startIceBearSession();
}
session::set('isAdmin',true);
$users=user::getAll(array(
		'sortby'=>'fullname',
		'all'=>1,
));
$users=$users['rows'];
array_shift($users); //don't want the IceBear Administrator
$superGroup=usergroup::getByName('Supervisors');
$supers=usergroup::getmembers($superGroup['id']);
$supervisorIds= (empty($supers)) ? array() : array_column($supers['rows'], 'id');

if(empty($supers)){
	echo '<p>No users were nominated as supervisors. You will need to set up the supervision hierarchy in IceBear later.</p>';
} else {
	echo '<p>Now we can tell IceBear who supervises who.</p>';
	echo '<p>Select each user\'s supervisor from the drop-down list. As you work, users will be moved under their supervisors.</p>';
	
	echo '<table><tr><th style="text-align:left;padding-left:1em">User</th><th style="text-align:right;padding-right:1em">Supervisor</th></tr></table>';
	
	$standardOptions=getOptions("bogus", "bogus", $supers, $superGroup);
	
	echo '<div id="users">';
	foreach($users as $u){
		if($u['fullname'] == 'IceBear Administrator'){ continue; }
		if(in_array($u['id'], $supervisorIds) || !empty($u['supervisorid'])){
			$options=getOptions($u['id'], $u['supervisorid'], $supers, $superGroup);
		} else {
			$options=$standardOptions;
		}
		echo '<div class="user" id="user'.$u['id'].'">
				<div class="head">'.$u['fullname'].'<select name="user_'.$u['id'].'_supervisorid">'.$options.'</select></div>
				<div class="supervisees"></div>
				</div>';
	}
	echo '</div>';
	
}

function getOptions($userId, $supervisorId, $supers, $superGroup){
	$options='<option value="">(none)</option>';
	foreach($supers['rows'] as $s){
		if($s['id']==$userId){ continue; }
		if($s['id']==$supervisorId){
			$options.='<option selected="selected" value="'.$s['id'].'">'.$s['fullname'].'</option>';
		} else { 
			$options.='<option value="'.$s['id'].'">'.$s['fullname'].'</option>';
		}
	}
	return $options;
}

?>
<p id="taint">Review the supervision hierarchy above. If you are happy with it, click "Next". Otherwise, make the changes you need and click "Update supervision hierarchy".</p>
<script type="text/javascript">
    let tainted = false;
    document.body.onload=function(){
	document.querySelectorAll("select").forEach(function(s){
		s.addEventListener("change", moveToSupervisor);
		doMoveToSupervisor(s);
	});
}

function moveToSupervisor(evt){
	let elem=evt.target;
	doMoveToSupervisor(elem);
	let n=document.getElementById("next");
	if(n){
		tainted=true;
		n.id="updatesupervisors";
		n.name="updatesupervisors";
		n.value="Update Supervision Hierarchy";
		document.querySelectorAll("taint").innerHTML='Click "Update Supervision Hierarchy" when you are happy with the information above. You will be able to review it afterwards. Then click "Next" to finish the installation.';
	}
}
function doMoveToSupervisor(elem){
	let supId=elem.value;
	elem=elem.closest("div.user");
	let subordinate=elem.querySelector("#user"+supId);
	if(subordinate){ alert("Cannot set subordinate as supervisor"); return false;  }
	
	let destination=document.getElementById("users");
	if(document.getElementById("user"+supId)){
		destination=document.getElementById("user"+supId).querySelector(".supervisees");
	}
	destination.append(elem.remove());
}

</script>