<?php

use PHPUnit\Framework\TestCase;

class userconfigTest extends TestCase {

	protected array $user1;
	protected array $user2;

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 * @throws NotFoundException
	 * @throws ForbiddenException
	 */
	public function setUp(): void {
		database::connect();
		database::begin();
		basesession::init(new DummySession());
		basesession::becomeAdmin();
		$now=time();
		$user1=user::create([
			'name'=>'user1_'.$now,
			'email'=>'user1_'.$now.'@bogus.bogus',
			'fullname'=>'user1_'.$now,
		]);
		$user2=user::create([
			'name'=>'user2_'.$now,
			'email'=>'user2_'.$now.'@bogus.bogus',
			'fullname'=>'user2_'.$now,
		]);
		$this->user1=$user1['created'];
		$this->user2=$user2['created'];
		database::query('INSERT INTO userconfig(userid,name,value) VALUES ('.$this->user1['id'].',"skin","testSkin")');
		database::query('INSERT INTO userconfig(userid,name,value) VALUES ('.$this->user2['id'].',"skin","default")');
		database::query('INSERT INTO userconfig(userid,name,value) VALUES ('.$this->user1['id'].',"foo","bar")');
		database::query('INSERT INTO userconfig(userid,name,value) VALUES ('.$this->user2['id'].',"foo","baz")');
		basesession::revokeAdmin();
	}
	public function tearDown(): void {
		database::abort();
		basesession::destroy();
	}

	/**
	 * @throws BadRequestException
	 * @throws AuthorizationRequiredException
	 * @throws ServerException
	 */
	public function testGet() {
		$skin=userconfig::get('skin');
		self::assertEquals('default', $skin);
		basesession::setUserToSession($this->user1['name']);
		$skin=userconfig::get('skin');
		self::assertEquals('testSkin', $skin);
		basesession::setUserToSession($this->user2['name']);
		$skin=userconfig::get('skin');
		self::assertEquals('default', $skin);
	}

	/**
	 * @throws BadRequestException
	 * @throws AuthorizationRequiredException
	 * @throws ServerException
	 */
	public function testSet() {
		basesession::setUserToSession($this->user1['name']);
		userconfig::set('skin','newSkin');
		self::assertEquals('newSkin',userconfig::get('skin'));
		basesession::setUserToSession($this->user2['name']);
		self::assertEquals('default',userconfig::get('skin'));

	}

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 */
	public function testSetNotLoggedIn() {
		self::expectException('AuthorizationRequiredException');
		userconfig::set('testing','value');
	}

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 * @throws AuthorizationRequiredException
	 */
	public function testGetAll() {
		$config=userconfig::getAll();
		self::assertCount(1, array_keys($config));
		self::assertArrayHasKey('skin', $config);
		self::assertEquals('default', $config['skin']);
		basesession::setUserToSession($this->user1['name']);
		$config=userconfig::getAll();
		self::assertArrayHasKey('skin', $config);
		self::assertEquals('testSkin', $config['skin']);
		self::assertCount(2, array_keys($config));
		basesession::setUserToSession($this->user2['name']);
		$config=userconfig::getAll();
		self::assertArrayHasKey('skin', $config);
		self::assertEquals('default', $config['skin']);
		self::assertCount(2, array_keys($config));
	}

	public function testGetById() {
		self::expectException('BadRequestException');
		self::expectExceptionMessageMatches('/not implemented/');
		userconfig::getById(1);
	}

	public function testGetByName() {
		self::expectException('BadRequestException');
		self::expectExceptionMessageMatches('/not implemented/');
		userconfig::getByName('foo');
	}

	public function testGetByProperty() {
		self::expectException('BadRequestException');
		self::expectExceptionMessageMatches('/not implemented/');
		userconfig::getByProperty('name','bob');
	}

	public function testGetByProperties() {
		self::expectException('BadRequestException');
		self::expectExceptionMessageMatches('/not implemented/');
		userconfig::getByProperties(['foo'=>'bar','bob'=>'fred']);
	}

}