<?php

use PHPUnit\Framework\TestCase;

class crystalscoreTest extends TestCase
{

    /**
     */
    protected function setUp(): void
    {
        database::connect();
		database::begin();
        try {
			$now=time();
            session::init(new DummySession());
            session::becomeAdmin();
			$user=user::create([
				'name'=>'user'.$now,
				'fullname'=>'user'.$now,
				'email'=>'user'.$now.'@bogus.bogus',
			])['created'];
            session::set('user', $user);
            session::set('userId', $user['id']);
        } catch (BadRequestException $e) {
            echo $e->getMessage();
            $this->fail('BadRequestException on session::init');
        } catch (NotFoundException) {
            $this->fail('NotFoundException on session::init');
        } catch (ServerException) {
            $this->fail('ServerException on session::init');
        } catch (ForbiddenException $e) {
			$this->fail('ForbiddenException on session::init');
		}
		try {
            $system = crystalscoringsystem::create(array('name' => 'test' . time()));
        } catch (BadRequestException) {
            $this->fail('BadRequestException on crystalscoringsystem::create');
        } catch (ForbiddenException) {
            $this->fail('ForbiddenException on crystalscoringsystem::create');
        } catch (NotFoundException) {
            $this->fail('NotFoundException on crystalscoringsystem::create');
        } catch (ServerException) {
            $this->fail('ServerException on crystalscoringsystem::create');
        }
        session::set('scoringSystemId',$system['created']['id']);
        session::revokeAdmin();
    }

    protected function tearDown(): void {
        database::abort();
        session::destroy();
    }

    /**
     * @throws BadRequestException
     */
    public function testCanCreateAsAdmin(){
        session::becomeAdmin();
        self::assertTrue(crystalscore::canCreate(), 'crystalscore::canCreate() returned false as admin');
    }

    /**
     * @throws NotFoundException
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws ServerException
     */
    public function testCanCreateAsTechnician(){
        session::becomeAdmin();
        $group=usergroup::getByName(usergroup::TECHNICIANS);
        groupmembership::create(array('userid'=>session::getUserId(), 'usergroupid'=>$group['id']));
        session::revokeAdmin();
        session::refreshProjectPermissions();
        self::assertTrue(crystalscore::canCreate(), 'crystalscore::canCreate() returned false as technician');
    }

    /**
     * @return void
     * @throws BadRequestException
     */
    public function testCanCreateAsNonAdmin(){
        self::assertFalse(crystalscore::canCreate(), 'crystalscore::canCreate() returned true as regular user');
    }

    /**
     * @throws NotFoundException
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws ServerException
     */
    public function testCreateAsAdmin(){
        session::becomeAdmin();
        $name='Test'.time();
        crystalscore::create(array(
            'name'=>$name,
            'label'=>$name,
            'hotkey'=>1,
            'scoreindex'=>1,
            'color'=>'ffffff',
            'crystalscoringsystemid'=>session::get('scoringSystemId')
        ));
        session::revokeAdmin();
        session::refreshProjectPermissions();
        $score=crystalscore::getByName($name);
        self::assertNotEmpty($score);
    }

    /**
     * @throws NotFoundException
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws ServerException
     */
    public function testCreateAsTechnician(){
        session::becomeAdmin();
        $group=usergroup::getByName(usergroup::TECHNICIANS);
        groupmembership::create(array('userid'=>session::getUserId(), 'usergroupid'=>$group['id']));
        session::revokeAdmin();
        session::refreshProjectPermissions();
        $name='Test'.time();
        crystalscore::create(array(
            'name'=>$name,
            'label'=>$name,
            'hotkey'=>1,
            'scoreindex'=>1,
            'color'=>'ffffff',
            'crystalscoringsystemid'=>session::get('scoringSystemId')
        ));
        $score=crystalscore::getByName($name);
        self::assertNotEmpty($score);
    }

}