<?php

use PHPUnit\Framework\TestCase;

class screenfromrockmakerTest extends TestCase
{

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 * @throws NotFoundException
	 */
	protected function setUp(): void
    {
        database::connect();
		database::begin();
		basesession::init(new DummySession());
    }

    protected function tearDown(): void {
        database::abort();
        session::destroy();
    }

	/**
	 * @throws ServerException
	 * @throws BadRequestException
	 */
	public function testGetAll() {
		session::set('RockMakerScreens',null);
		$manufacturers=screenfromrockmaker::getAll();
		self::assertIsArray($manufacturers);
		self::assertArrayHasKey('total',$manufacturers);
		self::assertArrayHasKey('rows',$manufacturers);
		self::assertCount(1 * $manufacturers["total"], $manufacturers['rows']);
		self::assertGreaterThan(0, count($manufacturers['rows']));
		$manufacturer=$manufacturers['rows'][0];
		self::assertIsArray($manufacturer);
		self::assertArrayHasKey('manufacturer',$manufacturer);
		self::assertArrayHasKey('screens',$manufacturer);
		self::assertGreaterThan(0, count($manufacturer['screens']));
		$screen=$manufacturer['screens'][0];
		self::assertIsArray($screen);
		self::assertArrayHasKey('manufacturer',$screen);
		self::assertArrayHasKey('catalognumber',$screen);
		self::assertArrayHasKey('name',$screen);
		self::assertArrayHasKey('path',$screen);
		self::assertArrayHasKey('installed',$screen);
	}
}