<?php
/*
 * Forces any recent imaging sessions whose first image is a .png to light type "UV".
 */

sleep(rand(2,10));
chdir(__DIR__);
require '../../vendor/autoload.php';

database::connect();
database::begin();

$imagingSessionIds=database::queryGetAll('SELECT id FROM imagingsession WHERE imagerid=20803644 AND lighttype<>"UV" ORDER BY id DESC LIMIT 20');
if($imagingSessionIds){
	$imagingSessionIds=array_column($imagingSessionIds['rows'], 'id');
	foreach($imagingSessionIds as $id){
		$image=database::queryGetOne('SELECT id FROM dropimage WHERE imagingsessionid=:id AND imagepath LIKE "%.png"', [':id'=>$id]);
		if(!$image){ continue; }
		database::query('UPDATE imagingsession SET lighttype="UV" WHERE id=:id', [':id'=>$id]);
	}
}

database::commit();