<?php
/**
 * Upgrades the database from version 1.8.0 to version 1.8.1
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */

Log::write(Log::LOGLEVEL_INFO, "In updater, from 1.8.0 to 1.8.1...");

Log::write(Log::LOGLEVEL_INFO, "There are no database changes.");

/**
 * A previous update replaced core/note.class.php with core/basenote.class.php and model/note.class.php.
 * However, core/note.class.php was left in place. Classloader complained that two classes with the same
 * name exist. core/note.class.php should be removed.
 */
Log::write(Log::LOGLEVEL_INFO, "Checking for existence of note.class.php in classes/core...");
$path=rtrim(__DIR__,'/').'../classes/core/note.class.php';
if(file_exists($path)){
    Log::write(Log::LOGLEVEL_INFO, "...exists. Removing...");
    @unlink($path);
    if(file_exists($path)){
        throw new ServerException("Tried to remove $path but it still exists");
    }
    Log::write(Log::LOGLEVEL_INFO, "...done");
} else {
    Log::write(Log::LOGLEVEL_INFO, "...does not exist, which is correct.");
}



Log::write(Log::LOGLEVEL_INFO, "...update done");

