<?php
/**
 * Upgrades the database from version 1.8.2 to version NEXT
 * DO NOT call this directly, it will fail.
 * To be included from classes/core/updater.class.php.
 * Assumes that logging has already been init()ed. Log class will throw ServerException if not.
 */
Log::write(Log::LOGLEVEL_INFO, "In updater, from 1.8.2 to 1.9.0...");

Log::write(Log::LOGLEVEL_INFO, "Forcing shipmentdestination.clientbaseuri and apibaseuri column nullable...");
database::addOrAlterColumn('shipmentdestination','apibaseuri','VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin NULL');
database::addOrAlterColumn('shipmentdestination','clientbaseuri','VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin NULL');
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Adding loglevel column to apikey...");
database::addOrAlterColumn('apikey','loglevel','TINYINT UNSIGNED NOT NULL DEFAULT 2');
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Adding bestresolution column to dataset...");
database::addOrAlterColumn('dataset','bestresolution','FLOAT UNSIGNED NULL DEFAULT NULL');
Log::write(Log::LOGLEVEL_INFO, "...done");

Log::write(Log::LOGLEVEL_INFO, "Setting bestresolution for existing datasets...");
$ids=database::queryGetAll('SELECT DISTINCT datasetid FROM autoprocessingresult');
if(!empty($ids)){
    if(isset($ids['rows'])){ $ids=$ids['rows']; }
    $ids=array_column($ids, 'datasetid');
    foreach($ids as $id){
        dataset::setBestResolutionFromAutoProcessingResults($id);
    }
}
Log::write(Log::LOGLEVEL_INFO, "...done");


Log::write(Log::LOGLEVEL_INFO, "...update done");

